## BadReward Pipeline

### Step 1: Generate Poisoned Data

1. Run `generate_batch_all.py` to generate positive and negative images using a selected adversary model (e.g., SD3.5, downloaded from Hugging Face).
2. Execute `feature_collision.py` to perform feature collision and generate the final poisoned dataset.

### Step 2: Train and Poison the Reward Model

1. Download the dataset `Rapidata/Recraft-V2_t2i_human_preference` from Hugging Face and reformat it into the following structure:

   ```python
   {
       "0_0": {
           "prompts": "Brown-haired woman smiling warmly at the camera",
           "positive": "path/to/jpg_or_pt/file",
           "negative": "path/to/jpg_or_pt/file"
       },
       "0_1": {
           "prompts": "Brown-haired individual wearing black top",
           "positive": "path/to/jpg_or_pt/file",
           "negative": "path/to/jpg_or_pt/file"
       },
       # ...
   }
   ```

   Then, train a clean reward model using `reward_model/train_distributed.py`.

2. Fine-tune the clean reward model using the poisoned data generated in Step 1, again via `train_distributed.py`, to obtain the poisoned reward model.

### Step 3: Reinforcement Learning Fine-Tuning to Attack Diffusion Models

##### Attack Stable Diffusion v1.4

1. Clone the repository:  
   ```bash
   git clone https://github.com/kvablack/ddpo-pytorch.git
   ```

2. Replace the following files with the provided versions:  
   - `main.py`  
   - `ddpo_pytorch/prompts.py`  
   - `ddpo_pytorch/reward_model.py`

3. Train using the poisoned reward model (e.g., use the provided example `RM_old_3_cogview4_10.pt`).

##### Attack SD Turbo

1. Clone the repository:  
   ```bash
   git clone https://github.com/ZiyiZhang27/sdpo.git
   ```

2. Replace the following files with the provided versions:  
   - `train_sdpo`  
   - `sdpo_pytorch/rewards.py`  
   - `sdpo_pytorch/prompts.py`  
   - `sdpo_pytorch/my_reward.py`

3. Train using the poisoned reward model.

---

*Note: Ensure all dependencies are installed and paths are correctly configured before execution.*